USE OLAP
--Filtering by Multiple Columns Using Default Parameteres
go
ALTER FUNCTION profit_by_order_method_type_filtered (
	@date varchar(120) = '%'
	,@city char(129) = '%'
	,@retailer_type char(120) = '%'
	--etc.
	) RETURNS table AS
RETURN SELECT order_method_type
       ,format(sum(profit),'C') as total_profit
FROM sales_enriched
WHERE cast(date as varchar(120)) like trim(@date)
and retailer_city like trim(@city)
and retailer_type like trim(@retailer_type)
GROUP BY order_method_type
go

--We can then filter based on whichever value or values I want
SELECT * FROM profit_by_order_method_type_filtered('2016-01-01',default,default)
SELECT * FROM profit_by_order_method_type_filtered(default,'Sydney',default)
SELECT * FROM profit_by_order_method_type_filtered(default,default,'Sports Store')
SELECT * FROM profit_by_order_method_type_filtered('2016-01-01',default,'Sports Store')